VERSION 5.00
Begin VB.Form MapEditor 
   Caption         =   "Bubble Bobble 83 Map Editor"
   ClientHeight    =   6180
   ClientLeft      =   165
   ClientTop       =   165
   ClientWidth     =   9375
   LinkTopic       =   "Form1"
   Picture         =   "BubbleEdit.frx":0000
   ScaleHeight     =   412
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   625
   Begin VB.PictureBox ActiveSpriteSet 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   1920
      Left            =   4560
      Picture         =   "BubbleEdit.frx":1242
      ScaleHeight     =   128
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   320
      TabIndex        =   20
      Top             =   2160
      Visible         =   0   'False
      Width           =   4800
   End
   Begin VB.CommandButton cmdMode 
      Caption         =   "Sprites"
      Height          =   255
      Index           =   1
      Left            =   1680
      Style           =   1  'Graphical
      TabIndex        =   19
      Top             =   0
      Width           =   855
   End
   Begin VB.CommandButton cmdMode 
      BackColor       =   &H80000014&
      Caption         =   "MAP"
      Height          =   255
      Index           =   0
      Left            =   840
      Style           =   1  'Graphical
      TabIndex        =   18
      Top             =   0
      Width           =   855
   End
   Begin VB.PictureBox picToolbar 
      BorderStyle     =   0  'None
      Height          =   750
      Left            =   0
      ScaleHeight     =   50
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   625
      TabIndex        =   9
      Top             =   0
      Width           =   9375
      Begin VB.TextBox txtPop 
         Height          =   285
         Left            =   2880
         MaxLength       =   3
         TabIndex        =   36
         Text            =   "255"
         Top             =   360
         Width           =   495
      End
      Begin VB.TextBox txtBaron 
         Height          =   285
         Left            =   1800
         MaxLength       =   3
         TabIndex        =   34
         Text            =   "5"
         Top             =   360
         Width           =   495
      End
      Begin VB.TextBox txtHurry 
         Height          =   285
         Left            =   600
         MaxLength       =   3
         TabIndex        =   31
         Text            =   "10"
         Top             =   360
         Width           =   495
      End
      Begin VB.CheckBox chkFlags 
         Caption         =   "Clear Bubbles"
         Height          =   255
         Index           =   3
         Left            =   6840
         TabIndex        =   30
         Top             =   480
         Width           =   1335
      End
      Begin VB.TextBox txtMapName 
         Height          =   285
         Left            =   7200
         TabIndex        =   17
         Text            =   "bubl"
         Top             =   0
         Width           =   855
      End
      Begin VB.CheckBox chkFlags 
         Caption         =   "Fire Bubbles"
         Height          =   255
         Index           =   2
         Left            =   5640
         TabIndex        =   29
         Top             =   480
         Width           =   1215
      End
      Begin VB.CheckBox chkFlags 
         Caption         =   "Thunder Bubbles"
         Height          =   255
         Index           =   1
         Left            =   5640
         TabIndex        =   28
         Top             =   240
         Width           =   1575
      End
      Begin VB.CheckBox chkFlags 
         Caption         =   "Water Bubbles"
         Height          =   255
         Index           =   0
         Left            =   5640
         TabIndex        =   27
         Top             =   0
         Width           =   1455
      End
      Begin VB.HScrollBar selector 
         Height          =   240
         Index           =   3
         Left            =   5040
         Max             =   2
         TabIndex        =   26
         Tag             =   "-1"
         Top             =   360
         Width           =   480
      End
      Begin VB.HScrollBar selector 
         Height          =   240
         Index           =   2
         Left            =   4440
         Max             =   2
         TabIndex        =   25
         Tag             =   "-1"
         Top             =   360
         Width           =   480
      End
      Begin VB.HScrollBar selector 
         Height          =   240
         Index           =   1
         Left            =   5040
         Max             =   2
         TabIndex        =   24
         Tag             =   "-1"
         Top             =   0
         Width           =   480
      End
      Begin VB.HScrollBar selector 
         Height          =   240
         Index           =   0
         Left            =   4440
         Max             =   2
         TabIndex        =   23
         Tag             =   "-1"
         Top             =   0
         Width           =   480
      End
      Begin VB.PictureBox picWall 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         Height          =   720
         Left            =   3600
         ScaleHeight     =   48
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   48
         TabIndex        =   22
         Top             =   0
         Width           =   720
      End
      Begin VB.CommandButton cmdSaveNow 
         Caption         =   "Save now!"
         Height          =   255
         Left            =   8280
         TabIndex        =   21
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton cmdReload 
         Caption         =   "[R]"
         Height          =   255
         Left            =   8640
         TabIndex        =   13
         Top             =   0
         Width           =   375
      End
      Begin VB.CommandButton cmdNext 
         Caption         =   "->"
         Height          =   255
         Left            =   9000
         TabIndex        =   12
         Top             =   0
         Width           =   375
      End
      Begin VB.CommandButton cmdBack 
         Caption         =   "<-"
         Height          =   255
         Left            =   8280
         TabIndex        =   11
         Top             =   0
         Width           =   375
      End
      Begin VB.CommandButton cmdZoom 
         Caption         =   "Zoom"
         Height          =   255
         Left            =   2520
         Style           =   1  'Graphical
         TabIndex        =   10
         Tag             =   "0"
         Top             =   0
         Width           =   975
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "Pop:"
         Height          =   195
         Left            =   2520
         TabIndex        =   35
         Top             =   360
         Width           =   330
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Baron:"
         Height          =   195
         Left            =   1320
         TabIndex        =   33
         Top             =   360
         Width           =   465
      End
      Begin VB.Label lblHurry 
         AutoSize        =   -1  'True
         Caption         =   "Hurry:"
         Height          =   195
         Left            =   120
         TabIndex        =   32
         Top             =   360
         Width           =   420
      End
      Begin VB.Label lblXY 
         AutoSize        =   -1  'True
         Caption         =   "X:0 Y:0"
         Height          =   195
         Left            =   0
         TabIndex        =   16
         Top             =   0
         Width           =   525
      End
   End
   Begin VB.PictureBox ActiveTileSet 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      Height          =   240
      Left            =   3000
      Picture         =   "BubbleEdit.frx":1F284
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   96
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   5400
      Visible         =   0   'False
      Width           =   1440
   End
   Begin VB.PictureBox tsetHolder 
      AutoRedraw      =   -1  'True
      BackColor       =   &H000000FF&
      FontTransparent =   0   'False
      Height          =   1020
      Left            =   0
      ScaleHeight     =   64
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   256
      TabIndex        =   5
      Top             =   840
      Width           =   3900
      Begin VB.PictureBox pTileset 
         AutoRedraw      =   -1  'True
         BackColor       =   &H000000C0&
         BorderStyle     =   0  'None
         Height          =   240
         Left            =   0
         ScaleHeight     =   16
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   256
         TabIndex        =   6
         Top             =   0
         Width           =   3840
         Begin VB.Shape sel1 
            BorderColor     =   &H0000FFFF&
            BorderStyle     =   6  'Inside Solid
            BorderWidth     =   2
            DrawMode        =   6  'Mask Pen Not
            Height          =   240
            Left            =   0
            Top             =   0
            Width           =   240
         End
         Begin VB.Shape PalBox 
            BorderStyle     =   6  'Inside Solid
            BorderWidth     =   2
            DrawMode        =   6  'Mask Pen Not
            Height          =   240
            Left            =   -240
            Top             =   0
            Width           =   240
         End
      End
   End
   Begin VB.HScrollBar TileScroller 
      Height          =   240
      LargeChange     =   128
      Left            =   0
      Max             =   512
      SmallChange     =   32
      TabIndex        =   4
      Top             =   1920
      Width           =   3615
   End
   Begin VB.HScrollBar HScroll 
      Height          =   240
      LargeChange     =   128
      Left            =   120
      Max             =   512
      SmallChange     =   64
      TabIndex        =   2
      Top             =   4800
      Width           =   3255
   End
   Begin VB.VScrollBar VScroll 
      Height          =   2175
      LargeChange     =   256
      Left            =   4200
      Max             =   512
      SmallChange     =   64
      TabIndex        =   1
      Top             =   2280
      Width           =   240
   End
   Begin VB.PictureBox Holder 
      BackColor       =   &H8000000C&
      Height          =   2055
      Left            =   0
      ScaleHeight     =   133
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   237
      TabIndex        =   0
      Top             =   2400
      Width           =   3615
      Begin VB.PictureBox Mapp 
         AutoRedraw      =   -1  'True
         BorderStyle     =   0  'None
         Height          =   3840
         Left            =   0
         ScaleHeight     =   256
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   256
         TabIndex        =   7
         Top             =   0
         Width           =   3840
         Begin VB.Shape MapCursor 
            BorderColor     =   &H00FFFFFF&
            BorderStyle     =   6  'Inside Solid
            BorderWidth     =   2
            DrawMode        =   6  'Mask Pen Not
            Height          =   240
            Left            =   0
            Top             =   0
            Width           =   240
         End
      End
   End
   Begin VB.TextBox Resizer 
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   4200
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   3
      Top             =   4920
      Width           =   255
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Width:"
      Height          =   195
      Left            =   0
      TabIndex        =   15
      Top             =   0
      Width           =   465
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Width:"
      Height          =   195
      Left            =   0
      TabIndex        =   14
      Top             =   0
      Width           =   465
   End
   Begin VB.Menu mnuPop 
      Caption         =   "&Pop Up Menu"
      Enabled         =   0   'False
      Visible         =   0   'False
      Begin VB.Menu mnuPlace 
         Caption         =   "&Place Here"
      End
      Begin VB.Menu mnuSetEnemy 
         Caption         =   "Set &Enemy"
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Bubble Buster/Zen Chan"
            Index           =   0
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Monsta/Beluga"
            Index           =   1
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Stoner/Maita"
            Index           =   2
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Drunk"
            Index           =   3
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&HullaBaloon"
            Index           =   4
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Coily/Banebou"
            Index           =   5
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Hidegonsu"
            Index           =   6
         End
         Begin VB.Menu mnuEnemy 
            Caption         =   "&Invader"
            Index           =   7
         End
      End
      Begin VB.Menu mnuXFlip 
         Caption         =   "&Face Left"
      End
      Begin VB.Menu mnuDelete 
         Caption         =   "&Delete"
      End
      Begin VB.Menu mnuSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuAdd 
         Caption         =   "&Add an enemy..."
      End
   End
End
Attribute VB_Name = "MapEditor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
DefLng A-Z

Const xMapSize = 24, yMapSize = 16
Const MaxSprite = 10
Dim map(xMapSize, yMapSize) As Integer
Private Type SpriteType
  X As Long
  Y As Long
  T As Long
  F As Boolean
End Type

Dim Sprites(MaxSprite) As SpriteType

Option Explicit
Const tHeight = 1
Const NumTiles = 5

Dim LevFlags
Dim sXpos, sYpos
Dim EditMode As Long
Dim xSpriteSize, ySpriteSize
Dim MapNumber As Long
Dim xTileSize, yTileSize, xStart, yStart, xEnd, yEnd
Dim xBrushSize, yBrushSize, Brush(xMapSize, yMapSize)
Dim Wall(3, 3) As Long
Dim NumSprite
Dim optBrushSize
Dim ZoomFactor As Single
Dim SelectedObj

Function Hex2$(ByVal value)
Dim T$

T$ = Hex$(value)
If (Len(T$) \ 2) * 2 <> Len(T$) Then T$ = "0" + T$
Hex2$ = T$

End Function

Sub SaveMap()
  Dim Buffer As String, Buffer2 As String, Line As String, X, Y, z, L
  Dim FileName As String
  FileName = txtMapName + ".z80"
  On Error GoTo SaveError
  
  'Get bubble flags
  LevFlags = 0
  For X = 0 To 3
    If chkFlags(X).value Then LevFlags = LevFlags + 2 ^ (X + 4)
  Next
  
  'Set enemy count+bubble flags
  Buffer = Chr(NumSprite - 1 + LevFlags)
  
  'Set border holes
  LevFlags = 0
  For X = 0 To 3
    LevFlags = LevFlags + selector(X).value * 4 ^ X
  Next
  Buffer = Buffer + Chr(LevFlags)
  
  'Set 3 variables
  Buffer = Buffer + Chr(Val(txtHurry.Text))
  Buffer = Buffer + Chr(Val(txtBaron.Text))
  Buffer = Buffer + Chr(Val(txtPop.Text))
  
  'Set the Custom Tile
  'Part 1
  LevFlags = 0
  For Y = 0 To 1
  For X = 0 To 3
    LevFlags = LevFlags + Wall(X, Y) * 2 ^ ((3 - X) + (1 - Y) * 4)
  Next
  Next
  Buffer = Buffer + Chr(LevFlags)
  
  'Part 2
  LevFlags = 0
  For Y = 0 To 1
  For X = 0 To 3
    LevFlags = LevFlags + Wall(X, Y + 2) * 2 ^ ((3 - X) + (1 - Y) * 4)
  Next
  Next
  Buffer = Buffer + Chr(LevFlags)
  
  'Dump the fruit and powerup, and all the other enemies
  For X = 0 To NumSprite + 1
    z = Sprites(X).X
    If Sprites(X).F And X > 1 Then z = z + 128
    Buffer = Buffer + Chr(z)
    z = Sprites(X).Y \ 2
    If X > 1 Then z = z + Sprites(X).T * 32
    Buffer = Buffer + Chr(z)
  Next
  X = 1: Y = 1
  
  'Dump the map
  z = -1
  Do
    If map(X, Y) <> z Then
      If z <> -1 Then Buffer = Buffer + Chr(L - 1 + z * 32)
      L = 0
      z = map(X, Y)
    End If
    If map(X, Y) = z Then
      L = L + 1
    End If
    If L = 32 Then
      Buffer = Buffer + Chr(31 + z * 32)
      L = 0
      z = -1
    End If
    X = X + 1
    If X = xMapSize - 1 Then
      Y = Y + 1
      X = 1
    End If
    If Y = yMapSize - 1 Then Exit Do
  Loop
  If L > 0 Then Buffer = Buffer + Chr(L - 1 + z * 32)
  Buffer = Buffer + Chr(255)
  Buffer2 = ";map " + Str(MapNumber)
  X = 0
  Do
    If X Mod 20 = 0 Then
      Buffer2 = Buffer2 + vbCrLf + " .db $"
    Else
      Buffer2 = Buffer2 + ",$"
    End If
    Buffer2 = Buffer2 + Hex2(Asc(Mid(Buffer, X + 1, 1)))
    X = X + 1
    If X >= Len(Buffer) Then Exit Do
  Loop
  Buffer2 = Buffer2 + vbCrLf
  Y = 0
  Open FileName For Binary As #1
  If LOF(1) = 0 Then
'    Put 1, , Buffer2
    Close
'    Exit Sub
  End If
  Close
  Open FileName For Input As #1
  Open "maptemp.txt" For Output As #2
    Do
      If DoFileLine(Line, True) Then Exit Do
      If LCase(Left(Line, 5)) = ";map " Then
        z = Val(Mid(Line, 5))
        If z < MapNumber Then Print #2, Line
        If z = MapNumber Then
          Y = 1
          Print #2, Buffer2
          If DoFileLine(Line, False) Then Exit Do
          Print #2, Line
        End If
        If z > MapNumber Then
          If Y = 0 Then
            Print #2, Buffer2
          End If
          Print #2, Line
        End If
      End If
    Loop
  If Y = 0 Then Print #2, Buffer2
  Close
  Close
  FileCopy "maptemp.txt", FileName
  Kill "maptemp.txt"
  Exit Sub
SaveError:
  MsgBox "Error " + Error + " occurred when saving " + FileName
  Close
End Sub

Function DoFileLine(ByRef Line As String, bRite As Boolean)
  Do
    If EOF(1) Then
      DoFileLine = -1
      Exit Do
    End If
    Line Input #1, Line
    If LCase(Left(Line, 5)) = ";map " Then Exit Do
    If bRite Then Print #2, Line
  Loop
End Function

Sub LoadMap()
  Dim FileName As String, Buffer As String, Line As String, Pos, X, Y, z, L, T, q, temp(2)
  On Error GoTo LoadError
  FileName = txtMapName + ".z80"
  'Create a blank map!  First, fill the map with Up air and walls...
  For Y = 0 To yMapSize
    map(0, Y) = 0
    For X = 1 To xMapSize - 1
      map(X, Y) = 1
    Next
    map(23, Y) = 0
  Next
  For X = 0 To xMapSize
    map(X, 0) = 0
    map(X, 15) = 0
  Next
  'Reset sprites to defaults, out of the way.
  Erase Sprites
  For X = 0 To 2
    Sprites(X).X = 92
    Sprites(X).Y = 4 + X * 8
  Next
  NumSprite = 1
  Sprites(0).T = 8
  Sprites(1).T = 9
  'Then reset the holes, now floors
  For X = 0 To 3
    selector(X).Tag = False
    selector(X).value = 0
    selector(X).Tag = True
  Next
  'Reset variables
  txtHurry.Text = "5"
  txtBaron.Text = "2"
  txtPop.Text = "85"
  chkFlags(0).value = 0
  chkFlags(1).value = 0
  chkFlags(2).value = 0
  chkFlags(3).value = 0
  
  
  'Now begin code.
  
  X = 0: Y = 0
     
  Open FileName For Binary As #1
  If LOF(1) = 0 Then
    Close
    Exit Sub
  End If
  Close
  Open FileName For Input As #1
    Do
      If DoFileLine(Line, False) Then Exit Do
      If LCase(Left(Line, 5)) = ";map " And Val(Mid(Line, 5)) = MapNumber Then
        Do
          Line Input #1, Line
          If Left(Line, 4) = " .db" Then
            Buffer = Buffer + Line
          Else
            Exit Do
          End If
        Loop
        If Len(Buffer) = 0 Then Exit Do
        Pos = 0
        
        'Get Enemycount/Bubbleflag byte
        T = GetAByte(Pos, Buffer)
        NumSprite = (T And 7) + 1
        LevFlags = (T And &HF8)
        
        For X = 0 To 3
          chkFlags(X).value = 0
          If LevFlags And (2 ^ (X + 4)) Then chkFlags(X).value = 1
        Next
        
        'Get Borders
        T = GetAByte(Pos, Buffer)
        For X = 0 To 3
          selector(X).Tag = False
          selector(X).value = (T And (3 * 4 ^ X)) \ (4 ^ X)
          selector(X).Tag = True
        Next
        
        'Get Counters
        T = GetAByte(Pos, Buffer)
        txtHurry.Text = Trim(Str(T))
        T = GetAByte(Pos, Buffer)
        txtBaron.Text = Trim(Str(T))
        T = GetAByte(Pos, Buffer)
        txtPop.Text = Trim(Str(T))
        
        'Get Tiles
        T = GetAByte(Pos, Buffer)
        For X = 0 To 3
        For Y = 0 To 1
          Wall(X, Y) = 0
          If T And 2 ^ (3 - X + 4 * (1 - Y)) Then Wall(X, Y) = 1
        Next
        Next
       
        T = GetAByte(Pos, Buffer)
        For X = 0 To 3
        For Y = 0 To 1
          Wall(X, Y + 2) = 0
          If T And 2 ^ (3 - X + 4 * (1 - Y)) Then Wall(X, Y + 2) = 1
        Next
        Next
        
        For q = 0 To NumSprite + 1
          X = GetAByte(Pos, Buffer)
          Y = GetAByte(Pos, Buffer)
          Sprites(q).X = X And 127
          Sprites(q).Y = (Y And 31) * 2
          T = (Y And &HE0) \ 32
          If q < 2 Then T = T + 8 + q
          Sprites(q).T = T
          Sprites(q).F = X And &H80
        Next
        X = 1: Y = 1
        Do
          T = GetAByte(Pos, Buffer)
          If Pos > Len(Buffer) Then Exit Do
          If T = 255 Then Exit Do
          z = T \ 32
          L = T And 31
          For T = 0 To L
            map(X, Y) = z
            X = X + 1
            If X = xMapSize - 1 Then
              X = 1
              Y = Y + 1
            End If
            If Y = yMapSize - 1 Then
              Exit Do
            End If
          Next
        Loop
        Exit Do
      End If
    Loop
  Close

  UpdateWall

  UpdateTops
  
  UpdateWorkspace
Exit Sub
LoadError:
  MsgBox "Error " + Error + " occurred when loading " + FileName
  Close
End Sub
Sub OldLoadMap()
  Dim FileName As String, Buffer As String, Line As String, Pos, X, Y, z, L, T, q, temp(2)
  On Error GoTo OldLoadError
  FileName = txtMapName + ".z80"
  For Y = 0 To yMapSize
  For X = 0 To xMapSize
    map(X, Y) = 0
  Next
  Next
  Erase Sprites
  NumSprite = 1
  Sprites(0).T = 8
  Sprites(1).X = 8
  Sprites(1).T = 9
  Sprites(2).X = 16
  X = 0: Y = 0
   
  Open FileName For Binary As #1
  If LOF(1) = 0 Then
    Close
    Exit Sub
  End If
  Close
  Open FileName For Input As #1
    Do
      If DoFileLine(Line, False) Then Exit Do
      If LCase(Left(Line, 5)) = ";map " And Val(Mid(Line, 5)) = MapNumber Then
        Do
          Line Input #1, Line
          If Left(Line, 4) = " .db" Then
            Buffer = Buffer + Line
          Else
            Exit Do
          End If
        Loop
        If Len(Buffer) = 0 Then Exit Do
        Pos = 0
        
        T = GetAByte(Pos, Buffer)
        NumSprite = (T And 7) + 1
        LevFlags = (T And &HF8)
        
        For q = 0 To NumSprite + 1
          X = GetAByte(Pos, Buffer)
          Y = GetAByte(Pos, Buffer)
          Sprites(q).X = X And 127
          Sprites(q).Y = (Y And 31) * 2
          T = (Y And &HE0) \ 32
          If q < 2 Then T = T + 8 + q
          Sprites(q).T = T
          Sprites(q).F = X And &H80
        Next
        X = 1: Y = 1
        Do
          T = GetAByte(Pos, Buffer)
          If Pos > Len(Buffer) Then Exit Do
          If T = 255 Then Exit Do
          z = T \ 32
          L = T And 31
          For T = 0 To L
            map(X, Y) = z
            X = X + 1
            If X = xMapSize - 1 Then
              X = 1
              Y = Y + 1
            End If
            If Y = yMapSize - 1 Then
              Exit Do
            End If
          Next
        Loop
        Exit Do
      End If
    Loop
  Close
  
  
  
  UpdateWorkspace
Exit Sub
OldLoadError:
  MsgBox "Error " + Error + " occurred when loading " + FileName
  Close
End Sub

Function GetAByte(ByRef Pos As Long, ByRef Buffer As String)
  Do
    Pos = Pos + 1
    If Mid(Buffer, Pos, 1) = "$" Then
      GetAByte = Val("&H" + Mid(Buffer, Pos + 1, 2))
      Exit Function
    End If
    If Pos > Len(Buffer) Then Exit Function
  Loop
End Function


Sub SwapIfLess(ByRef num1, ByRef num2)
  Dim num3
  If num1 < num2 Then
    num3 = num1
    num1 = num2
    num2 = num3
  End If
End Sub


Sub Start()
  SelectedObj = -1
  ZoomFactor = 1
  xStart = -1
  xTileSize = 16
  yTileSize = 16
  xBrushSize = 0
  yBrushSize = 0
  xSpriteSize = 32
  ySpriteSize = 32
  LoadMap
  UpdateWall
  UpdateTileset
  UpdateWorkspace
End Sub

Sub DrawTile(X, Y)
  Dim T, z, x1, y1, x2, y2
  With Mapp
    T = map(X, Y) And 255
    z = BitBlt(.hDC, X * xTileSize, Y * yTileSize, xTileSize, yTileSize, ActiveTileSet.hDC, T * xTileSize, 0, SRCCOPY)
    T = map(X, Y) \ 256
    If T > 0 Then
      x1 = X * xTileSize
      x2 = x1 + xTileSize - 1
      y1 = Y * yTileSize
      y2 = y1 + yTileSize - 1
    End If
  End With
  DrawSprites
End Sub

Sub DrawMap()
  Dim X, Y, T, z
  Dim x1, y1, x2, y2
  With Mapp
    For X = 0 To xMapSize
    For Y = 0 To yMapSize
      T = map(X, Y) And 255
      z = BitBlt(.hDC, X * xTileSize, Y * yTileSize, xTileSize, yTileSize, ActiveTileSet.hDC, T * xTileSize, 0, SRCCOPY)
      T = map(X, Y) \ 256
      If T > 0 Then
        x1 = X * xTileSize
        x2 = x1 + xTileSize - 1
        y1 = Y * yTileSize
        y2 = y1 + yTileSize - 1
      End If
    Next
    Next
  End With
  DrawSprites
End Sub

Sub DrawSprites()
  Dim X, Y, z, i
  Dim x1, y1, w, h, x2, y2
  With Mapp
    For i = 0 To NumSprite + 1
      x1 = Sprites(i).X * ZoomFactor * 4
      y1 = Sprites(i).Y * ZoomFactor * 4
      w = xSpriteSize
      h = ySpriteSize
      x2 = xSpriteSize * Sprites(i).T
      y2 = 0
      If Sprites(i).F Then y2 = ySpriteSize * 2
      z = BitBlt(.hDC, x1, y1, w, h, ActiveSpriteSet.hDC, x2, y2 + h, SRCAND)
      z = BitBlt(.hDC, x1, y1, w, h, ActiveSpriteSet.hDC, x2, y2, SRCPAINT)
    Next
    .Refresh
  End With
End Sub

Sub UpdateWorkspace()
  Dim X, z
  With Mapp
    .Width = xTileSize * xMapSize
    .Height = yTileSize * yMapSize
  End With
  DrawMap

End Sub


Sub UpdateTileset()
  Dim X, Y, z
  With pTileset
    .Width = xTileSize * NumTiles
    .Height = yTileSize
    For X = 0 To 4
      z = BitBlt(.hDC, X * xTileSize, 0 * yTileSize, xTileSize, yTileSize, ActiveTileSet.hDC, X * xTileSize, 0, SRCCOPY)
    Next
    .Refresh
  End With
End Sub

Private Sub cmdBack_Click()
  If MapNumber <= 0 Then
    MapNumber = 0
    Beep
    Exit Sub
  End If
  SaveMap
  MapNumber = MapNumber - 1
  cmdReload.Caption = Str(MapNumber + 1)
  LoadMap
End Sub

Private Sub cmdBrushSize_Click(Index As Integer)
  Dim i
  For i = 0 To cmdBrushSize.Count - 1
    cmdBrushSize(i).BackColor = &H8000000F
  Next
  cmdBrushSize(Index).BackColor = &H80000016
  optBrushSize = Index
End Sub

Private Sub cmdMode_Click(Index As Integer)
cmdMode(Index).BackColor = vb3DHighlight
cmdMode(Index Xor 1).BackColor = vbButtonFace
EditMode = Index
If Index = 0 Then
  MapCursor.Width = xTileSize
  MapCursor.Height = yTileSize
Else
  MapCursor.Width = xSpriteSize
  MapCursor.Height = ySpriteSize
End If
End Sub

Private Sub cmdNext_Click()
  If MapNumber >= 255 Then
    MapNumber = 255
    Beep
    Exit Sub
  End If
  SaveMap
  MapNumber = MapNumber + 1
  cmdReload.Caption = Str(MapNumber + 1)
  LoadMap
End Sub

Private Sub cmdReload_Click()
  If MsgBox("Reload! Are you sure?", vbYesNo) = vbYes Then LoadMap
'  If MsgBox("Reload! Are you sure?", vbYesNo) = vbYes Then OldLoadMap
End Sub

Private Sub cmdSaveNow_Click()
  SaveMap
End Sub

Private Sub cmdZoom_Click()
  If cmdZoom.Tag = "" Then cmdZoom.Tag = 0
  cmdZoom.Tag = Not cmdZoom.Tag
  If cmdZoom.Tag Then
    ZoomFactor = 2
    cmdZoom.BackColor = &H80000016
    With ActiveTileSet
      xTileSize = xTileSize * 2
      yTileSize = yTileSize * 2
      .Width = .Width * 2
      .Height = .Height * 2
      .PaintPicture .Picture, 0, 0, .Width, .Height, , , .Width \ 2, .Height \ 2, vbSrcCopy
        sel1.Width = sel1.Width * 2
        sel1.Height = sel1.Height * 2
        MapCursor.Width = MapCursor.Width * 2
        MapCursor.Height = MapCursor.Height * 2
        MapCursor.Left = MapCursor.Left * 2
        MapCursor.Top = MapCursor.Top * 2
      .Refresh
    End With
    With ActiveSpriteSet
      xSpriteSize = xSpriteSize * 2
      ySpriteSize = ySpriteSize * 2
      .Width = .Width * 2
      .Height = .Height * 2
      .PaintPicture .Picture, 0, 0, .Width, .Height, , , .Width \ 2, .Height \ 2, vbSrcCopy
      .Refresh
    End With
    Me.WindowState = vbMaximized
  Else
    ZoomFactor = 1
    cmdZoom.BackColor = &H8000000F
    With ActiveTileSet
      xTileSize = xTileSize \ 2
      yTileSize = yTileSize \ 2
      .PaintPicture .Picture, 0, 0, .Width \ 2, .Height \ 2, , , , , vbSrcCopy
      .Width = .Width \ 2
      .Height = .Height \ 2
        sel1.Width = sel1.Width \ 2
        sel1.Height = sel1.Height \ 2
        MapCursor.Width = MapCursor.Width \ 2
        MapCursor.Height = MapCursor.Height \ 2
        MapCursor.Left = MapCursor.Left \ 2
        MapCursor.Top = MapCursor.Top \ 2
      .Refresh
    End With
    With ActiveSpriteSet
      xSpriteSize = xSpriteSize \ 2
      ySpriteSize = ySpriteSize \ 2
      .PaintPicture .Picture, 0, 0, .Width \ 2, .Height \ 2, , , , , vbSrcCopy
      .Width = .Width \ 2
      .Height = .Height \ 2
      .Refresh
    End With
    
    Me.WindowState = vbNormal
  End If
  UpdateTileset
  UpdateWorkspace
  Form_Resize
  UpdateWall
End Sub


Private Sub Form_Load()
txtMapName.Text = App.Path + "\bubl"
Start
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  Select Case MsgBox("Save map?", vbYesNoCancel)
    Case vbYes
      SaveMap
    Case vbCancel
      Cancel = True
  End Select
End Sub

Private Sub Form_Resize()
Dim fHeight, fWidth
Dim Scrollval
fHeight = MapEditor.ScaleHeight: fWidth = MapEditor.ScaleWidth

On Error Resume Next

With tsetHolder
  .Left = 0
  .Width = fWidth
  .Height = pTileset.Height + 4
End With

With TileScroller
  .Left = 0
  .Width = fWidth
  .Top = tsetHolder.Height + tsetHolder.Top
  .Height = 16
  Scrollval = pTileset.Width - tsetHolder.ScaleWidth
  If Scrollval > 0 Then
    If .value > Scrollval Then .value = Scrollval
    .Max = Scrollval
    .Enabled = True
    .Visible = True
    .Height = 16
  Else
    If .value <> 0 Then .value = 0
    .Enabled = False
    .Visible = False
    .Height = 0
  End If
End With

With Resizer
  .Left = fWidth - 17
  .Top = fHeight - 17
End With

With Holder
  .Left = 0
  .Top = TileScroller.Height + TileScroller.Top
  .Width = fWidth - 16 - .Left
  .Height = fHeight - 16 - .Top
End With

With HScroll
  .Top = fHeight - 16
  .Left = Holder.Left
  .Width = fWidth - .Left - 16
  Scrollval = Mapp.Width - Holder.ScaleWidth
  If Scrollval > 0 Then
    If .value > Scrollval Then .value = Scrollval
    .Max = Scrollval
    .Enabled = True
  Else
    If .value <> 0 Then .value = 0
    .Enabled = False
  End If
End With

With VScroll
  .Top = Holder.Top
  .Left = fWidth - 16
  .Height = fHeight - .Top - 16
  Scrollval = Mapp.Height - Holder.ScaleHeight
  If Scrollval > 0 Then
    If .value > Scrollval Then .value = Scrollval
    .Max = Scrollval
    .Enabled = True
  Else
    If .value <> 0 Then .value = 0
    .Enabled = False
  End If
End With
  
End Sub

Private Sub HScroll_Change()
  Mapp.Left = -HScroll.value
End Sub

Private Sub HScroll_Scroll()
  HScroll_Change
End Sub


Private Sub Mapp_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim x1, y1, x2, y2, xPos, yPos, CurX, CurY, i, T, CurOBJ
  If EditMode = 0 Then
    Mapp_MouseMove Button, Shift, X, Y
  Else
    CurOBJ = -1
    With Mapp
      If X > .Width - 1 Or X < 0 Or Y > .Height - 1 Or Y < 0 Then Exit Sub
    End With
    xPos = X \ 4 \ ZoomFactor
    yPos = (Y \ 8 \ ZoomFactor) * 2
    
    If Button <= 1 Then
      For i = 0 To NumSprite + 1
        x1 = Sprites(i).X
        y1 = Sprites(i).Y
        If xPos >= x1 And xPos <= x1 + 7 And yPos >= y1 And yPos <= y1 + 7 Then
          If SelectedObj = i Then Exit For
          xPos = x1
          yPos = y1
          If Button = 1 Then SelectedObj = i
          Exit For
        End If
      Next
    End If
    
    lblXY.Caption = "X:" + Trim(Str(xPos)) + " Y:" + Trim(Str(yPos))
    
    MapCursor.Left = xPos * 4 * ZoomFactor
    MapCursor.Top = yPos * 4 * ZoomFactor
    
    If Button = 2 Then
      sXpos = xPos
      sYpos = yPos
      If SelectedObj < 2 Then
        mnuSetEnemy.Enabled = False
        mnuXFlip.Enabled = False
        mnuXFlip.Checked = False
        mnuDelete.Enabled = False
      Else
        mnuDelete.Enabled = True
        If NumSprite < 2 Then mnuDelete.Enabled = False
        mnuSetEnemy.Enabled = True
        mnuXFlip.Enabled = True
        mnuXFlip.Checked = Sprites(SelectedObj).F
        For X = 0 To 7
          mnuEnemy(X).Checked = False
        Next
        mnuEnemy(Sprites(SelectedObj).T).Checked = True
      End If
      If SelectedObj < 0 Then
        mnuPlace.Enabled = False
      Else
        mnuPlace.Enabled = True
      End If
      If NumSprite > 8 Then mnuAdd.Enabled = False
      If NumSprite <= 8 Then mnuAdd.Enabled = True
      
      MapEditor.PopupMenu mnuPop
    End If
  End If
End Sub

Private Sub Mapp_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim x1, y1, x2, y2, xPos, yPos, CurX, CurY, i, T, CurOBJ
  If EditMode = 0 Then
    With Mapp
      If X > .Width Or X < 0 Or Y > .Height Or Y < 0 Then Exit Sub
    End With
    xPos = X \ xTileSize
    yPos = Y \ yTileSize
    
    If Button And Not 2 Then
      If xPos + xBrushSize >= xMapSize Then xPos = xMapSize - xBrushSize - 1
      If yPos + yBrushSize >= yMapSize Then yPos = yMapSize - yBrushSize - 1
    End If
    
    lblXY.Caption = "X:" + Trim(Str(xPos)) + " Y:" + Trim(Str(yPos))
    
    x1 = xPos * xTileSize
    y1 = yPos * yTileSize
    If Button = 0 Then
      With MapCursor
        .Left = x1
        .Top = y1
        .Width = xBrushSize * xTileSize + xTileSize
        .Height = yBrushSize * yTileSize + yTileSize
      End With
    ElseIf Button = 1 Then
      With MapCursor
        .Left = x1
        .Top = y1
        .Width = xBrushSize * xTileSize + xTileSize
        .Height = yBrushSize * yTileSize + yTileSize
      End With
      If xBrushSize = 0 And yBrushSize = 0 Then
        If Brush(0, 0) > 255 Then
          map(xPos, yPos) = map(xPos, yPos) Or Brush(0, 0)
        ElseIf Brush(0, 0) = -1 Then
          map(xPos, yPos) = map(xPos, yPos) And 255
        Else
          map(xPos, yPos) = Brush(0, 0)
        End If
        DrawTile xPos, yPos
      Else
        For CurX = 0 To xBrushSize
        For CurY = 0 To yBrushSize
          map(CurX + xPos, CurY + yPos) = Brush(CurX, CurY)
          DrawTile CurX + xPos, CurY + yPos
        Next
        Next
      Mapp.Refresh
      End If
    ElseIf Button = 2 Then
      
      If xPos >= xMapSize Then xPos = xMapSize - 1
      If xPos < 0 Then xPos = 0
      If yPos > yMapSize Then yPos = yMapSize
      If yPos < 0 Then yPos = 0
      
      If xStart = -1 Then
        xStart = xPos
        yStart = yPos
      End If
      
      With MapCursor
        If xPos < xStart Then
          .Left = xPos * xTileSize
        Else
          .Left = xStart * xTileSize
        End If
        If yPos < yStart Then
          .Top = yPos * yTileSize
        Else
          .Top = yStart * yTileSize
        End If
        .Width = xBrushSize * xTileSize + xTileSize
        .Height = yBrushSize * yTileSize + yTileSize
      End With
      
      xBrushSize = Abs(xStart - xPos)
      yBrushSize = Abs(yStart - yPos)
      
      xEnd = xPos
      yEnd = yPos
    End If
  Else
    CurOBJ = -1
    With Mapp
      If X > .Width - 1 Or X < 0 Or Y > .Height - 1 Or Y < 0 Then Exit Sub
    End With
    xPos = X \ 4 \ ZoomFactor
    yPos = (Y \ 8 \ ZoomFactor) * 2
    
    If Button <= 1 Then
      For i = 0 To NumSprite + 1
        x1 = Sprites(i).X
        y1 = Sprites(i).Y
        If xPos >= x1 And xPos <= x1 + 7 And yPos >= y1 And yPos <= y1 + 7 Then
          If SelectedObj = i Then Exit For
          xPos = x1
          yPos = y1
          'If Button = 1 Then SelectedObj = I
          Exit For
        End If
      Next
    End If
    
    lblXY.Caption = "X:" + Trim(Str(xPos)) + " Y:" + Trim(Str(yPos))
    
    MapCursor.Left = xPos * 4 * ZoomFactor
    MapCursor.Top = yPos * 4 * ZoomFactor
  End If
End Sub

Private Sub Mapp_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim CurX, CurY
 If EditMode = 0 Then
  If Button = 2 Then
    SwapIfLess xEnd, xStart
    SwapIfLess yEnd, yStart
    If xStart < 0 Then Exit Sub
    If yStart < 0 Then Exit Sub
    xBrushSize = Abs(xEnd - xStart)
    yBrushSize = Abs(yEnd - yStart)
    For CurX = 0 To xBrushSize
    For CurY = 0 To yBrushSize
      Brush(CurX, CurY) = map(xStart + CurX, yStart + CurY)
    Next
    Next
    sel1.Left = Brush(0, 0) * xTileSize
    xStart = -1: yStart = -1
  End If
 Else
  
 End If
End Sub

Private Sub mnuAdd_Click()
  NumSprite = NumSprite + 1
  SelectedObj = NumSprite + 1
  Sprites(SelectedObj).X = sXpos
  Sprites(SelectedObj).Y = sYpos
  Sprites(SelectedObj).T = 0
  Sprites(SelectedObj).F = False
  DrawMap
End Sub

Private Sub mnuDelete_Click()
  Dim X
  NumSprite = NumSprite - 1
  Sprites(SelectedObj).F = False
  Sprites(SelectedObj).X = 0
  Sprites(SelectedObj).Y = 0
  Sprites(SelectedObj).T = 0
  For X = SelectedObj To NumSprite + 1
    Sprites(X).X = Sprites(X + 1).X
    Sprites(X).Y = Sprites(X + 1).Y
    Sprites(X).T = Sprites(X + 1).T
    Sprites(X).F = Sprites(X + 1).F
  Next
  SelectedObj = -1
  DrawMap
End Sub

Private Sub mnuEnemy_Click(Index As Integer)
  Sprites(SelectedObj).T = Index
  DrawMap
End Sub

Private Sub mnuPlace_Click()
  Sprites(SelectedObj).X = sXpos
  Sprites(SelectedObj).Y = sYpos
  DrawMap
End Sub

Private Sub mnuXFlip_Click()
  Sprites(SelectedObj).F = Not Sprites(SelectedObj).F
  DrawMap
End Sub



Sub UpdateWall()
  Dim X, Y, c
  For X = 0 To 3
  For Y = 0 To 3
    c = 0
    If Wall(X, Y) = 0 Then c = &HFFFFFF
    picWall.Line (X * 12, Y * 12)-(X * 12 + 11, Y * 12 + 11), c, BF
    ActiveTileSet.Line (X * 4 * ZoomFactor, Y * 4 * ZoomFactor)-((X + 1) * 4 * ZoomFactor - 1, (Y + 1) * 4 * ZoomFactor - 1), c, BF
  Next
  Next
  picWall.Refresh
  ActiveTileSet.Refresh
  DrawMap
  
End Sub

Private Sub picWall_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  picWall_MouseMove Button, Shift, X, Y
End Sub

Private Sub picWall_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Dim x1, y1
  x1 = X \ 12
  y1 = Y \ 12
  If x1 < 0 Or x1 > 3 Or y1 < 0 Or y1 > 3 Then Exit Sub
  If Button = 1 Then
    Wall(x1, y1) = 1
    UpdateWall
  End If
  If Button = 2 Then
    Wall(x1, y1) = 0
    UpdateWall
  End If
End Sub

Private Sub pTileset_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  If EditMode = 1 Then Exit Sub
  pTileset_MouseMove Button, Shift, X, Y
End Sub

Private Sub pTileset_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  If EditMode = 1 Then Exit Sub
  Dim x1, y1, z, CurX, CurY
  x1 = X \ xTileSize
  y1 = Y \ yTileSize
  z = (y1 Mod tHeight) + (x1 * tHeight)
  If z > 239 Or z < 0 Then Exit Sub
  If Button And 2 Then
    Select Case Brush(0, 0)
      Case Is > 255
        For CurX = 0 To xMapSize
        For CurY = 0 To yMapSize
          If (map(CurX, CurY) And 255) = z Then map(CurX, CurY) = map(CurX, CurY) Or Brush(0, 0)
        Next
        Next
      Case -1
        For CurX = 0 To xMapSize
        For CurY = 0 To yMapSize
          If (map(CurX, CurY) And 255) = z Then map(CurX, CurY) = map(CurX, CurY) And 255
        Next
        Next
      Case Else
        If MsgBox("Are you sure you want to replace all of those tiles?", vbYesNoCancel) <> vbYes Then Exit Sub
        For CurX = 0 To xMapSize
        For CurY = 0 To yMapSize
          If (map(CurX, CurY) And 255) = z Then map(CurX, CurY) = map(CurX, CurY) And (Not 255) Or Brush(0, 0)
        Next
        Next
    End Select
    DrawMap
    Exit Sub
  End If
  If Button Then
    xBrushSize = optBrushSize
    yBrushSize = optBrushSize
    For CurX = 0 To xBrushSize
    For CurY = 0 To yBrushSize
      Brush(CurX, CurY) = z
    Next
    Next
    sel1.Visible = True
    sel1.Left = x1 * xTileSize
    sel1.Top = y1 * yTileSize
  End If
End Sub

Private Sub selector_Change(Index As Integer)
  If selector(Index).Tag = False Then Exit Sub
  UpdateTops
End Sub
Sub UpdateTops()
  Dim X, Y, i, z
  For i = 0 To 3
    z = selector(i).value
    If z = 2 Then z = 4
    Y = (i And 2) * 7.5
    For X = 8 * (i And 1) + 6 To 8 * (i And 1) + 9
      map(X, Y) = z
    Next
  Next
  DrawMap
      
  
  
  
End Sub


Private Sub TileScroller_Change()
  pTileset.Left = -TileScroller.value
End Sub

Private Sub TileScroller_Scroll()
  TileScroller_Change
End Sub

Private Sub topSelector1_Change()

End Sub

Private Sub VScroll_Change()
  Mapp.Top = -VScroll.value
End Sub

Private Sub VScroll_Scroll()
  VScroll_Change
End Sub
